/*
 * Decompiled with CFR 0.152.
 */
package com.starmicronics.starjavapos.Star;

import com.starmicronics.stario.StarPrinterStatus;
import com.starmicronics.starjavapos.Star.POSPrinterStarBase;
import com.starmicronics.utility.POSPrinter.BMPImageProcessor;
import com.starmicronics.utility.POSPrinter.MapModeConversion;
import com.starmicronics.utility.POSPrinter.Star.CommandStarDot;
import com.starmicronics.utility.POSPrinter.Star.PrinterFontStarDot;
import java.awt.Image;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.ImageIcon;
import jpos.JposException;
import jpos.config.JposEntry;
import jpos.events.JposEvent;
import jpos.events.StatusUpdateEvent;
import jpos.services.POSPrinterService113;

public class POSPrinterStarDot
extends POSPrinterStarBase
implements POSPrinterService113,
ActionListener {
    private List m_transactionOutputQueue = null;
    private boolean m_transaction = false;
    private boolean m_asyncMode = false;
    private boolean m_recLetterQuality = false;
    private double m_recDotDimensionHeight = 0.353;
    private double m_recDotDimensionWidth = 0.3;
    private boolean m_cap2Color = true;
    private boolean m_capCoverOpen = true;
    private MapModeConversion m_recMapMode = new MapModeConversion();
    private int m_capRecMarkFeed = 0;

    public POSPrinterStarDot(JposEntry jposEntry, boolean[] blArray) throws JposException {
        super(jposEntry, blArray);
        this.m_recMapMode.setDotDimensionHeight(this.m_recDotDimensionHeight);
        this.m_recMapMode.setDotDimensionWidth(this.m_recDotDimensionWidth);
        this.m_capCoverOpen = (Boolean)jposEntry.getPropertyValue("coverOpen");
        this.m_cap2Color = (Boolean)jposEntry.getPropertyValue("cap2Color");
        this.m_recPrinterFont = new PrinterFontStarDot((Integer)jposEntry.getPropertyValue("dotLineWidth"));
        this.m_recPrintMethods = new CommandStarDot(this.m_recPrinterFont, this.m_recMapMode, jposEntry);
        this.m_physicalDeviceDescription = "Star Micronics single station dot printer";
    }

    public int getCapCharacterSet() throws JposException {
        return 998;
    }

    public boolean getCapConcurrentJrnRec() throws JposException {
        return false;
    }

    public boolean getCapConcurrentJrnSlp() throws JposException {
        return false;
    }

    public boolean getCapConcurrentRecSlp() throws JposException {
        return false;
    }

    public boolean getCapCoverSensor() throws JposException {
        return this.m_capCoverOpen;
    }

    public boolean getCapJrn2Color() throws JposException {
        return false;
    }

    public boolean getCapJrnBold() throws JposException {
        return false;
    }

    public boolean getCapJrnDhigh() throws JposException {
        return false;
    }

    public boolean getCapJrnDwide() throws JposException {
        return false;
    }

    public boolean getCapJrnDwideDhigh() throws JposException {
        return false;
    }

    public boolean getCapJrnEmptySensor() throws JposException {
        return false;
    }

    public boolean getCapJrnItalic() throws JposException {
        return false;
    }

    public boolean getCapJrnNearEndSensor() throws JposException {
        return false;
    }

    public boolean getCapJrnPresent() throws JposException {
        return false;
    }

    public boolean getCapJrnUnderline() throws JposException {
        return false;
    }

    public boolean getCapRec2Color() throws JposException {
        return this.m_cap2Color;
    }

    public boolean getCapRecBarCode() throws JposException {
        return false;
    }

    public boolean getCapRecBitmap() throws JposException {
        return true;
    }

    public boolean getCapRecBold() throws JposException {
        return true;
    }

    public boolean getCapRecDhigh() throws JposException {
        return true;
    }

    public boolean getCapRecDwide() throws JposException {
        return true;
    }

    public boolean getCapRecDwideDhigh() throws JposException {
        return true;
    }

    public boolean getCapRecEmptySensor() throws JposException {
        return true;
    }

    public boolean getCapRecItalic() throws JposException {
        return false;
    }

    public boolean getCapRecLeft90() throws JposException {
        return false;
    }

    public boolean getCapRecNearEndSensor() throws JposException {
        return false;
    }

    public boolean getCapRecPapercut() throws JposException {
        return true;
    }

    public boolean getCapRecPresent() throws JposException {
        return true;
    }

    public boolean getCapRecRight90() throws JposException {
        return false;
    }

    public boolean getCapRecRotate180() throws JposException {
        return true;
    }

    public boolean getCapRecStamp() throws JposException {
        return true;
    }

    public boolean getCapRecUnderline() throws JposException {
        return true;
    }

    public boolean getCapSlp2Color() throws JposException {
        return false;
    }

    public boolean getCapSlpBarCode() throws JposException {
        return false;
    }

    public boolean getCapSlpBitmap() throws JposException {
        return false;
    }

    public boolean getCapSlpBold() throws JposException {
        return false;
    }

    public boolean getCapSlpDhigh() throws JposException {
        return false;
    }

    public boolean getCapSlpDwide() throws JposException {
        return false;
    }

    public boolean getCapSlpDwideDhigh() throws JposException {
        return false;
    }

    public boolean getCapSlpEmptySensor() throws JposException {
        return false;
    }

    public boolean getCapSlpFullslip() throws JposException {
        return false;
    }

    public boolean getCapSlpItalic() throws JposException {
        return false;
    }

    public boolean getCapSlpLeft90() throws JposException {
        return false;
    }

    public boolean getCapSlpNearEndSensor() throws JposException {
        return false;
    }

    public boolean getCapSlpPresent() throws JposException {
        return false;
    }

    public boolean getCapSlpRight90() throws JposException {
        return false;
    }

    public boolean getCapSlpRotate180() throws JposException {
        return false;
    }

    public boolean getCapSlpUnderline() throws JposException {
        return false;
    }

    public boolean getCapTransaction() throws JposException {
        return true;
    }

    public int getCapPowerReporting() throws JposException {
        return 2;
    }

    public int getCapJrnCartridgeSensor() throws JposException {
        return 0;
    }

    public int getCapJrnColor() throws JposException {
        return 0;
    }

    public int getCapRecCartridgeSensor() throws JposException {
        return 0;
    }

    public int getCapRecColor() throws JposException {
        if (this.m_cap2Color) {
            return 3;
        }
        return 1;
    }

    public int getCapRecMarkFeed() throws JposException {
        if (1 != this.m_capRecMarkFeed && 2 != this.m_capRecMarkFeed && 4 != this.m_capRecMarkFeed && 8 != this.m_capRecMarkFeed) {
            throw new JposException(106, "This request is illegal because the parameter is invalid.");
        }
        return this.m_capRecMarkFeed;
    }

    public boolean getCapSlpBothSidesPrint() throws JposException {
        return false;
    }

    public int getCapSlpCartridgeSensor() throws JposException {
        return 0;
    }

    public int getCapSlpColor() throws JposException {
        return 0;
    }

    public boolean getCapMapCharacterSet() throws JposException {
        return false;
    }

    public boolean getCapStatisticsReporting() throws JposException {
        return false;
    }

    public boolean getCapUpdateStatistics() throws JposException {
        return false;
    }

    public boolean getCapCompareFirmwareVersion() throws JposException {
        return false;
    }

    public boolean getCapConcurrentPageMode() throws JposException {
        return false;
    }

    public boolean getCapRecPageMode() throws JposException {
        return false;
    }

    public boolean getCapSlpPageMode() throws JposException {
        return false;
    }

    public boolean getCapUpdateFirmware() throws JposException {
        return false;
    }

    public int getCapRecRuledLine() throws JposException {
        return 0;
    }

    public int getCapSlpRuledLine() throws JposException {
        return 0;
    }

    public boolean getAsyncMode() throws JposException {
        return this.m_asyncMode;
    }

    public void setAsyncMode(boolean bl) throws JposException {
        this.m_asyncMode = bl;
    }

    public int getCharacterSet() throws JposException {
        return this.m_recPrinterFont.getCharacterSet();
    }

    public void setCharacterSet(int n) throws JposException {
        this.verifyDeviceEnabledState();
        this.m_recPrinterFont.setCharacterSet(n);
    }

    public String getCharacterSetList() throws JposException {
        return this.m_recPrinterFont.getCharacterSetList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getCoverOpen() throws JposException {
        this.verifyDeviceEnabledState();
        StarPrinterStatus[] starPrinterStatusArray = this.m_cachedStatus;
        synchronized (this.m_cachedStatus) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.m_cachedStatus[0].coverOpen;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getErrorLevel() throws JposException {
        int[] nArray = this.m_serviceState;
        synchronized (this.m_serviceState) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.m_errorLevel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getErrorStation() throws JposException {
        int[] nArray = this.m_serviceState;
        synchronized (this.m_serviceState) {
            if (1 == this.m_errorLevel) {
                throw new JposException(106, "This request failed because an error was not detected.");
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return 2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getErrorString() throws JposException {
        int[] nArray = this.m_serviceState;
        synchronized (this.m_serviceState) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.m_errorString;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getFlagWhenIdle() throws JposException {
        int[] nArray = this.m_serviceState;
        synchronized (this.m_serviceState) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.m_flagWhenIdle;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFlagWhenIdle(boolean bl) throws JposException {
        int[] nArray = this.m_serviceState;
        synchronized (this.m_serviceState) {
            this.m_flagWhenIdle = bl;
            if (this.m_flagWhenIdle && this.getState() == 2) {
                this.addEvent((JposEvent)new StatusUpdateEvent((Object)this, 1001));
                this.m_flagWhenIdle = false;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public String getFontTypefaceList() throws JposException {
        return "";
    }

    public boolean getJrnEmpty() throws JposException {
        return false;
    }

    public boolean getJrnLetterQuality() throws JposException {
        return false;
    }

    public void setJrnLetterQuality(boolean bl) throws JposException {
        this.verifyDeviceEnabledState();
        throw new JposException(106, "This request failed because this device does not support this print station.");
    }

    public int getJrnLineChars() throws JposException {
        return 0;
    }

    public void setJrnLineChars(int n) throws JposException {
        this.verifyDeviceEnabledState();
        throw new JposException(106, "This request failed because this device does not support this print station.");
    }

    public String getJrnLineCharsList() throws JposException {
        return "";
    }

    public int getJrnLineHeight() throws JposException {
        return 0;
    }

    public void setJrnLineHeight(int n) throws JposException {
        this.verifyDeviceEnabledState();
        throw new JposException(106, "This request failed because this device does not support this print station.");
    }

    public int getJrnLineSpacing() throws JposException {
        return 0;
    }

    public void setJrnLineSpacing(int n) throws JposException {
        this.verifyDeviceEnabledState();
        throw new JposException(106, "This request failed because this device does not support this print station.");
    }

    public int getJrnLineWidth() throws JposException {
        return 0;
    }

    public boolean getJrnNearEnd() throws JposException {
        return false;
    }

    public int getMapMode() throws JposException {
        return this.m_recMapMode.getMapMode();
    }

    public void setMapMode(int n) throws JposException {
        this.m_recMapMode.setMapMode(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getOutputID() throws JposException {
        Object object = this.m_asyncOutputLock;
        synchronized (object) {
            return this.m_outputId;
        }
    }

    public String getRecBarCodeRotationList() throws JposException {
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getRecEmpty() throws JposException {
        this.verifyDeviceEnabledState();
        StarPrinterStatus[] starPrinterStatusArray = this.m_cachedStatus;
        synchronized (this.m_cachedStatus) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.m_cachedStatus[0].receiptPaperEmpty;
        }
    }

    public boolean getRecLetterQuality() throws JposException {
        return this.m_recLetterQuality;
    }

    public void setRecLetterQuality(boolean bl) throws JposException {
        this.verifyDeviceEnabledState();
        this.m_recLetterQuality = bl;
    }

    public int getRecLineChars() throws JposException {
        return this.m_recPrinterFont.getLineChars();
    }

    public void setRecLineChars(int n) throws JposException {
        this.verifyDeviceEnabledState();
        this.m_recPrinterFont.setLineChars(n);
    }

    public String getRecLineCharsList() throws JposException {
        return this.m_recPrinterFont.getLineCharsList();
    }

    public int getRecLineHeight() throws JposException {
        return this.m_recMapMode.dotToMapMode(9, this.m_recDotDimensionHeight);
    }

    public void setRecLineHeight(int n) throws JposException {
        this.verifyDeviceEnabledState();
    }

    public int getRecLineSpacing() throws JposException {
        return this.m_recMapMode.dotToMapMode(this.m_recPrinterFont.getDotLineSpacing(), this.m_recDotDimensionHeight);
    }

    public void setRecLineSpacing(int n) throws JposException {
        this.verifyDeviceEnabledState();
        this.m_recPrinterFont.setDotLineSpacing(this.m_recMapMode.mapModeToDot(n, this.m_recDotDimensionHeight));
    }

    public int getRecLinesToPaperCut() throws JposException {
        return this.m_recPrinterFont.getRecLinesToPaperCut();
    }

    public int getRecLineWidth() throws JposException {
        return this.m_recMapMode.dotToMapMode(this.m_recPrinterFont.getLineWidthDot(), this.m_recDotDimensionWidth);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getRecNearEnd() throws JposException {
        StarPrinterStatus[] starPrinterStatusArray = this.m_cachedStatus;
        synchronized (this.m_cachedStatus) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.m_cachedStatus[0].receiptPaperNearEmptyInner;
        }
    }

    public int getRecSidewaysMaxChars() throws JposException {
        return 0;
    }

    public int getRecSidewaysMaxLines() throws JposException {
        return 0;
    }

    public int getRotateSpecial() throws JposException {
        return this.m_recPrintMethods.getRotateSpecial();
    }

    public void setRotateSpecial(int n) throws JposException {
        this.m_recPrintMethods.setRotateSpecial(n);
    }

    public String getSlpBarCodeRotationList() throws JposException {
        return "";
    }

    public boolean getSlpEmpty() throws JposException {
        this.verifyDeviceEnabledState();
        return false;
    }

    public boolean getSlpLetterQuality() throws JposException {
        return false;
    }

    public void setSlpLetterQuality(boolean bl) throws JposException {
        this.verifyDeviceEnabledState();
        throw new JposException(106, "This request failed because this device does not support this print station.");
    }

    public int getSlpLineChars() throws JposException {
        return 0;
    }

    public void setSlpLineChars(int n) throws JposException {
        this.verifyDeviceEnabledState();
        throw new JposException(106, "This request failed because this device does not support this print station.");
    }

    public String getSlpLineCharsList() throws JposException {
        return "";
    }

    public int getSlpLineHeight() throws JposException {
        return 0;
    }

    public void setSlpLineHeight(int n) throws JposException {
        this.verifyDeviceEnabledState();
        throw new JposException(106, "This request failed because this device does not support this print station.");
    }

    public int getSlpLinesNearEndToEnd() throws JposException {
        return 0;
    }

    public int getSlpLineSpacing() throws JposException {
        return 0;
    }

    public void setSlpLineSpacing(int n) throws JposException {
        this.verifyDeviceEnabledState();
        throw new JposException(106, "This request failed because this device does not support this print station.");
    }

    public int getSlpLineWidth() throws JposException {
        return 0;
    }

    public int getSlpMaxLines() throws JposException {
        return 0;
    }

    public boolean getSlpNearEnd() throws JposException {
        return false;
    }

    public int getSlpSidewaysMaxChars() throws JposException {
        return 0;
    }

    public int getSlpSidewaysMaxLines() throws JposException {
        return 0;
    }

    public int getCartridgeNotify() throws JposException {
        return 0;
    }

    public void setCartridgeNotify(int n) throws JposException {
        if (n != 0) {
            throw new JposException(106, "This request failed because this device does not support cartidge notify.");
        }
    }

    public int getJrnCartridgeState() throws JposException {
        return 0x10000000;
    }

    public int getJrnCurrentCartridge() throws JposException {
        return 0;
    }

    public void setJrnCurrentCartridge(int n) throws JposException {
        this.verifyDeviceEnabledState();
        throw new JposException(106, "This request failed because this device does not support this cartidge.");
    }

    public int getRecCartridgeState() throws JposException {
        return 0x10000000;
    }

    public int getRecCurrentCartridge() throws JposException {
        return 0;
    }

    public void setRecCurrentCartridge(int n) throws JposException {
        this.verifyDeviceEnabledState();
        throw new JposException(106, "This request failed because this device does not support this cartidge.");
    }

    public int getSlpCartridgeState() throws JposException {
        return 0x10000000;
    }

    public int getSlpCurrentCartridge() throws JposException {
        return 0;
    }

    public void setSlpCurrentCartridge(int n) throws JposException {
        this.verifyDeviceEnabledState();
        throw new JposException(106, "This request failed because this device does not support this cartidge.");
    }

    public int getSlpPrintSide() throws JposException {
        return 0;
    }

    public boolean getMapCharacterSet() throws JposException {
        return false;
    }

    public void setMapCharacterSet(boolean bl) throws JposException {
        throw new JposException(106, "This request failed because this device does not support MapCharacterSet.");
    }

    public String getRecBitmapRotationList() throws JposException {
        return "0,180";
    }

    public String getSlpBitmapRotationList() throws JposException {
        return "";
    }

    public String getPageModeArea() throws JposException {
        return "";
    }

    public int getPageModeDescriptor() throws JposException {
        return 0;
    }

    public int getPageModeHorizontalPosition() throws JposException {
        return 0;
    }

    public void setPageModeHorizontalPosition(int n) throws JposException {
        throw new JposException(106, "This request failed because this device does not support PageMode.");
    }

    public String getPageModePrintArea() throws JposException {
        return "";
    }

    public void setPageModePrintArea(String string) throws JposException {
        throw new JposException(106, "This request failed because this device does not support PageMode.");
    }

    public int getPageModePrintDirection() throws JposException {
        return 0;
    }

    public void setPageModePrintDirection(int n) throws JposException {
        throw new JposException(106, "This request failed because this device does not support PageMode.");
    }

    public int getPageModeStation() throws JposException {
        return 0;
    }

    public void setPageModeStation(int n) throws JposException {
        throw new JposException(106, "This request failed because this device does not support PageMode.");
    }

    public int getPageModeVerticalPosition() throws JposException {
        return 0;
    }

    public void setPageModeVerticalPosition(int n) throws JposException {
        throw new JposException(106, "This request failed because this device does not support PageMode.");
    }

    public void beginInsertion(int n) throws JposException {
        this.verifyDeviceEnabledState();
        throw new JposException(106, "This request is illegal because the specified station is unsupported.");
    }

    public void beginRemoval(int n) throws JposException {
        this.verifyDeviceEnabledState();
        throw new JposException(106, "This request is illegal because the specified station is unsupported.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearOutput() throws JposException {
        this.verifyClaimedState();
        if (null != this.m_transactionOutputQueue) {
            this.m_transactionOutputQueue = null;
            this.m_transaction = false;
        }
        this.m_recPrintMethods.setRotatePrint(1);
        Object object = this.m_asyncOutputLock;
        synchronized (object) {
            this.m_clearOutputPending = true;
            while (this.m_processingAsyncOutput) {
                try {
                    if (!this.m_clearOutputPending) {
                        this.m_processingAsyncOutput = false;
                        continue;
                    }
                    this.m_asyncOutputLock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (null != this.m_asyncOutputQueue) {
                this.m_asyncOutputQueue.clear();
            }
        }
        object = this.m_eventLock;
        synchronized (object) {
            Enumeration enumeration = this.m_eventQueue.elements();
            while (enumeration.hasMoreElements()) {
                this.m_eventQueue.clear();
            }
            this.setServiceState(2);
        }
        object = this.m_asyncOutputLock;
        synchronized (object) {
            this.m_clearOutputPending = false;
            this.m_asyncOutputLock.notifyAll();
        }
    }

    public void cutPaper(int n) throws JposException {
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        this.verifyDeviceEnabledState();
        if (!this.m_asyncMode) {
            if (2 != this.getState()) {
                throw new JposException(113, "This request is illegal because the service is busy processing asynchronous output.");
            }
            if (this.m_cachedStatus[0].coverOpen) {
                throw new JposException(114, 201, "This request is illegal because the cover is opened.");
            }
            if (this.m_cachedStatus[0].receiptPaperEmpty) {
                throw new JposException(114, 203, "This request is illegal because the receipt paper is empty.");
            }
        }
        arrayList.add(this.m_recPrintMethods.paperCutCommand(n, false, true));
        if (this.m_transaction) {
            this.m_transactionOutputQueue.add(arrayList);
        } else if (this.m_asyncMode) {
            this.addAsyncOutput(arrayList);
        } else {
            this.outputData(arrayList);
        }
    }

    public void endInsertion() throws JposException {
        this.verifyDeviceEnabledState();
        throw new JposException(106, "This request is illegal because the specified station is unsupported.");
    }

    public void endRemoval() throws JposException {
        this.verifyDeviceEnabledState();
        throw new JposException(106, "This request is illegal because the specified station is unsupported.");
    }

    public void printBarCode(int n, String string, int n2, int n3, int n4, int n5, int n6) throws JposException {
        throw new JposException(106, "This request is illegal because the specified station is unsupported.");
    }

    public void printBitmap(int n, String string, int n2, int n3) throws JposException {
        List list = null;
        Image image = null;
        this.verifyDeviceEnabledState();
        if (2 != n) {
            throw new JposException(106, "This request is illegal because the specified station is unsupported.");
        }
        if (!this.m_asyncMode) {
            if (2 != this.getState()) {
                throw new JposException(106, "This request is illegal because the service is busy processing asynchronous output.");
            }
            if (this.m_cachedStatus[0].coverOpen) {
                throw new JposException(114, 201, "This request is illegal because the cover is opened.");
            }
            if (this.m_cachedStatus[0].receiptPaperEmpty) {
                throw new JposException(114, 203, "This request is illegal because the receipt paper is empty.");
            }
        }
        if (-11 != n2) {
            if (0 > n2) {
                throw new JposException(106, "This request failed because the width parameter is not valid.");
            }
            n2 = this.m_recMapMode.mapModeToDot(n2, this.m_recDotDimensionWidth);
        }
        if (-1 != n3 && -2 != n3 && -3 != n3) {
            if (0 > n3) {
                throw new JposException(106, "This request failed because the aligment parameter is not valid.");
            }
            n3 = this.m_recMapMode.mapModeToDot(n3, this.m_recDotDimensionWidth);
        }
        try {
            image = string.toLowerCase().endsWith(".bmp") ? BMPImageProcessor.getImageFromBMPFile(string) : new ImageIcon(string).getImage();
        }
        catch (Exception exception) {
            throw new JposException(109);
        }
        if (259 == this.m_recPrintMethods.getRotateBitmap()) {
            list = this.m_recPrintMethods.bitmapCommand(image, n2, n3, 259);
        } else if (1 == this.m_recPrintMethods.getRotateBitmap()) {
            list = this.m_recPrintMethods.bitmapCommand(image, n2, n3, 1);
        } else {
            throw new JposException(106);
        }
        if (this.m_transaction) {
            this.m_transactionOutputQueue.add(list);
        } else if (this.m_asyncMode) {
            this.addAsyncOutput(list);
        } else {
            this.outputData(list);
        }
    }

    public void printImmediate(int n, String string) throws JposException {
        List list = null;
        this.verifyDeviceEnabledState();
        if (2 != n) {
            throw new JposException(106, "This request is illegal because the specified station is unsupported.");
        }
        if (this.m_cachedStatus[0].coverOpen) {
            throw new JposException(114, 201, "This request is illegal because the cover is opened.");
        }
        if (this.m_cachedStatus[0].receiptPaperEmpty) {
            throw new JposException(114, 203, "This request is illegal because the receipt paper is empty.");
        }
        list = this.m_recPrintMethods.parseEscapeSequences(0, string, false);
        this.outputData(list);
    }

    public void printNormal(int n, String string) throws JposException {
        List list = null;
        if (2 != n) {
            throw new JposException(106, "This request is illegal because the specified station is unsupported.");
        }
        if (!this.m_asyncMode) {
            if (2 != this.getState()) {
                throw new JposException(113, "This request is illegal because the service is busy processing asynchronous output.");
            }
            if (this.m_cachedStatus[0].coverOpen) {
                throw new JposException(114, 201, "This request is illegal because the cover is opened.");
            }
            if (this.m_cachedStatus[0].receiptPaperEmpty) {
                throw new JposException(114, 203, "This request is illegal because the receipt paper is empty.");
            }
        }
        list = this.m_recPrintMethods.parseEscapeSequences(0, string, false);
        if (this.m_transaction) {
            this.m_transactionOutputQueue.add(list);
        } else if (this.m_asyncMode) {
            this.addAsyncOutput(list);
        } else {
            this.outputData(list);
        }
    }

    public void printTwoNormal(int n, String string, String string2) throws JposException {
        throw new JposException(106, "This request failed because this device does not support this print station.");
    }

    public void rotatePrint(int n, int n2) throws JposException {
        this.verifyDeviceEnabledState();
        if (2 != n) {
            throw new JposException(106, "This request failed because the specified print station does not support this operation.");
        }
        if (!this.getCapRecBarCode() && 4096 == (n2 & 0x1000)) {
            throw new JposException(106, "This request failed because the specified print station does not support this operation.");
        }
        this.m_recPrintMethods.setRotatePrint(n2);
    }

    public void setBitmap(int n, int n2, String string, int n3, int n4) throws JposException {
        this.verifyDeviceEnabledState();
        if (!this.getCapRecBitmap()) {
            throw new JposException(106, "This request failed because the specified print station does not support this operation.");
        }
        if (2 == n2) {
            if (-11 != n3) {
                if (0 > n3) {
                    throw new JposException(106, "This request failed because the width parameter is not valid.");
                }
                n3 = this.m_recMapMode.mapModeToDot(n3, this.m_recDotDimensionWidth);
            }
            if (-1 != n4 && -2 != n4 && -3 != n4) {
                if (0 > n4) {
                    throw new JposException(106, "This request failed because the aligment parameter is not valid.");
                }
                n4 = this.m_recMapMode.mapModeToDot(n4, this.m_recDotDimensionWidth);
            }
        } else {
            throw new JposException(106, "This request failed because the specified print station does not support this operation.");
        }
        this.m_recPrintMethods.setBitmap(n, string, n3, n4);
    }

    public void setLogo(int n, String string) throws JposException {
        this.verifyDeviceEnabledState();
        if (1 != n && 2 != n) {
            throw new JposException(106, "This request failed because the specified logo location is invalid.");
        }
        this.m_recPrintMethods.setLogo(n, string);
    }

    public void transactionPrint(int n, int n2) throws JposException {
        this.verifyDeviceEnabledState();
        if (2 != n) {
            throw new JposException(106, "This request failed because this request is not supported this print station.");
        }
        if (!this.m_asyncMode && 2 != this.getState()) {
            throw new JposException(106, "This request is illegal because the service is busy processing asynchronous output.");
        }
        if (11 == n2) {
            if (null != this.m_transactionOutputQueue) {
                throw new JposException(106, "This request is illegal because a transaction is already in progress.");
            }
            this.m_transactionOutputQueue = new ArrayList();
            this.m_transaction = true;
        } else {
            if (null == this.m_transactionOutputQueue) {
                throw new JposException(106, "This request is illegal because a transaction is not in progress.");
            }
            ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
            List list = null;
            while (!this.m_transactionOutputQueue.isEmpty()) {
                list = (List)this.m_transactionOutputQueue.remove(0);
                while (!list.isEmpty()) {
                    arrayList.add((byte[])list.remove(0));
                }
            }
            if (this.m_asyncMode) {
                this.addAsyncOutput(arrayList);
            } else {
                this.outputData(arrayList);
            }
            this.m_transactionOutputQueue = null;
            this.m_transaction = false;
        }
    }

    public void validateData(int n, String string) throws JposException {
        this.verifyDeviceEnabledState();
        if (2 != n) {
            throw new JposException(106, "This request failed because the specified print station does not support this operation.");
        }
        if (!this.m_asyncMode && 2 != this.getState()) {
            throw new JposException(106, "This request is illegal because the service is busy processing asynchronous output.");
        }
        this.m_recPrintMethods.parseEscapeSequences(0, string, true);
    }

    public void changePrintSide(int n) throws JposException {
        throw new JposException(106, "This request failed because this device does not support this print station.");
    }

    public void markFeed(int n) throws JposException {
        throw new JposException(106, "This function is not supported.");
    }

    public void resetStatistics(String string) throws JposException {
        throw new JposException(106, "This function is not supported.");
    }

    public void retrieveStatistics(String[] stringArray) throws JposException {
        throw new JposException(106, "This function is not supported.");
    }

    public void updateStatistics(String string) throws JposException {
        throw new JposException(106, "This function is not supported.");
    }

    public void clearPrintArea() throws JposException {
        throw new JposException(106, "This function is not supported.");
    }

    public void compareFirmwareVersion(String string, int[] nArray) throws JposException {
        throw new JposException(106, "This function is not supported.");
    }

    public void pageModePrint(int n) throws JposException {
        throw new JposException(106, "This function is not supported.");
    }

    public void updateFirmware(String string) throws JposException {
        throw new JposException(106, "This function is not supported.");
    }

    public void printMemoryBitmap(int n, byte[] byArray, int n2, int n3, int n4) throws JposException {
        throw new JposException(106, "This function is not supported.");
    }

    public void drawRuledLine(int n, String string, int n2, int n3, int n4, int n5) throws JposException {
        throw new JposException(106, "This function is not supported.");
    }
}

